program THE_QL_ALGORITHM;
{--------------------------------------------------------------------}
{  Alg11'5.pas   Pascal program for implementing Algorithm 11.5      }
{                                                                    }
{  NUMERICAL METHODS: Pascal Programs, (c) John H. Mathews 1995      }
{  To accompany the text:                                            }
{  NUMERICAL METHODS for Math., Science & Engineering, 2nd Ed, 1992  }
{  Prentice Hall, Englewood Cliffs, New Jersey, 07632, U.S.A.        }
{  Prentice Hall, Inc.; USA, Canada, Mexico ISBN 0-13-624990-6       }
{  Prentice Hall, International Editions:   ISBN 0-13-625047-5       }
{  This free software is compliments of the author.                  }
{  E-mail address:       in%"mathews@fullerton.edu"                  }
{                                                                    }
{  Algorithm 11.5 (The QL Method with Shifts).                       }
{  Section   11.4, Eigenvalues of Symmetric Matrices, Page 587       }
{--------------------------------------------------------------------}

  uses
    crt;

  const
    MaxR = 10;
    MaxS = 50;
  type
    SubS = 1..MaxR;
    VECTOR = array[SubS] of real;
    MATRIX = array[SubS, SubS] of real;
    LETTER = string[4];
    LETTERS = string[200];
    Status = (Done, Working);
    DoSome = (Go, New, Stop);
    MatType = (LowerT, Square, UpperT);
    Process = (Auto, Observe);

  var
    CountR, CountS, I, InRC, Inum, K, N, Sub: integer;
    A, A1: MATRIX;
    D: VECTOR;
    MaxA, Rnum, T: real;
    Ach, Ans: LETTER;
    Mess: LETTERS;
    Stat: Status;
    DoMo: DoSome;
    Mtype: MatType;
    Proc: Process;

  procedure Aoutput (A: MATRIX; K, N: integer);
    var
      Digits, Mdigits, C, R: integer;
      Log10: real;
  begin
    Log10 := LN(10);
    WRITELN;
    if K = 0 then
      WRITELN('The Matrix  A   is:')
    else
      WRITELN('The Matrix  A   is:');
    WRITELN('             ', K : 1);
    for R := 1 to N do
      begin
        WRITELN;
        for C := 1 to N - 1 do
          begin
            Digits := 7;
            if A[R, C] <> 0 then
              Mdigits := 1 + TRUNC(LN(ABS(A[R, C])) / Log10);
            if A[R, C] < 0 then
              Mdigits := Mdigits + 1;
            if Mdigits < 7 then
              Mdigits := 7;
            Digits := 14 - Mdigits;
            WRITE(A[R, C] : 15 : Digits, ' ');
          end;
        Digits := 7;
        if A[R, N] <> 0 then
          Mdigits := 1 + TRUNC(LN(ABS(A[R, N])) / Log10);
        if A[R, N] < 0 then
          Mdigits := Mdigits + 1;
        if Mdigits < 7 then
          Mdigits := 7;
        Digits := 14 - Mdigits;
        WRITE(A[R, N] : 15 : Digits);
        if N > 5 then
          WRITELN;
      end;
    WRITELN;
  end;                                       {End of procedure Aoutput}

  procedure QL_ITERATION (var A: MATRIX; var D: VECTOR; N: integer);
    const
      DELTA = 0.00000001;
    var
      Cond, J, M: integer;
      SH, SHIFT, R1, R2: real;
      C, E, P, R, S, Q: VECTOR;

    procedure A_TO_TRI;
      var
        J: integer;
    begin
      for J := 1 to N do
        D[J] := A[J, J];
      for J := 1 to N - 1 do
        E[J] := A[J, J + 1];
    end;

    procedure TRI_TO_A;
      var
        J: integer;
    begin
      for J := 1 to N do
        A[J, J] := D[J];
      for J := 1 to N - 1 do
        begin
          A[J, J + 1] := E[J];
          A[J + 1, J] := E[J];
        end;
    end;

    procedure Find_Shift;
      var
        B1, C1, D1: real;
    begin
      B1 := -(D[M + 1] + D[M]);
      C1 := D[M + 1] * D[M] - E[M] * E[M];
      D1 := SQRT(ABS(B1 * B1 - 4 * C1));
      if B1 > 0 then
        begin
          R1 := (-B1 - D1) / 2;
          R2 := 2 * C1 / (-B1 - D1);
        end
      else
        begin
          R1 := (-B1 + D1) / 2;
          R2 := 2 * C1 / (-B1 + D1);
        end;
      SH := R1;
      if ABS(D[M] - R2) < ABS(D[M] - R1) then
        SH := R2;
      writeln;
      write('the shift is  ');
      write(sh : 15 : 7);
      writeln;
      read(ans);
    end;

    procedure Form_L;
      var
        J: integer;
        P_J1, Q_J: real;
    begin
      for J := 1 to N do
        P[J] := D[J];
      for J := 1 to N - 1 do
        Q[J] := E[J];
      P_J1 := P[N];                 {P_J1 old value of P[J+1]}
      Q_J := Q[N - 1];                  {Q_J old value of Q[J]}
      for J := N - 1 downto M do
        begin
          P[J + 1] := SQRT(SQR(P_J1) + SQR(Q[J]));
          C[J] := P_J1 / P[J + 1];
          S[J] := Q[J] / P[J + 1];
          Q[J] := C[J] * Q_J + S[J] * D[J];
          P_J1 := C[J] * D[J] - S[J] * Q_J;
          if J > M then
             { R[J-1] := S[J]*Q[J-1];  dead code}
            Q_J := C[J] * Q[J - 1];
        end;
      P[M] := P_J1;
    end;

    procedure Form_A;
      var
        J: integer;
    begin
      D[N] := S[N - 1] * Q[N - 1] + C[N - 1] * P[N];
      E[N - 1] := S[N - 1] * P[N - 1];
      for J := N - 2 downto M do
        begin
          D[J + 1] := S[J] * Q[J] + C[J] * C[J + 1] * P[J + 1];
          E[J] := S[J] * P[J];
        end;
      D[M] := C[M] * P[M];
    end;

  begin                             {Start of PROCEDURE QL_ITERATION}
    if Proc = Observe then
      begin
        CLRSCR;
        Aoutput(A, 0, N);
      end;
    A_TO_TRI;
    SHIFT := 0;
    M := 1;
    while M <= N - 2 do
      begin
        K := 1;
        Cond := 0;
        while (K < 50) and (Cond = 0) do
          begin
            Find_Shift;
            if ABS(E[M]) > DELTA then
              begin
                SHIFT := SHIFT + SH;
                for J := M to N do
                  D[J] := D[J] - SH;
              end
            else
              begin
                writeln;
                write('the eigenvalue is ');
                D[M] := D[M] + SHIFT;
                writeln(D[M] : 15 : 7);
                writeln;
                readln(ans);
                M := M + 1;
                Cond := 1;
              end;
            Form_L;
            Form_A;
            if Proc = Observe then
              begin
                CLRSCR;
                TRI_TO_A;
                Aoutput(A, K, N);
                WRITELN;
                WRITELN;
                WRITE('     Press the <ENTER> key.  ');
                READLN(ANS);
              end;
            K := K + 1;
          end;
      end;
    Find_Shift;
    D[N - 1] := R1 + SHIFT;
    D[N] := R2 + SHIFT;
    for J := 1 to N - 1 do
      E[J] := 0;
    TRI_TO_A;
  end;                                 {End of PROCEDURE QL_ITERATION}

  procedure INPUTMATRIX (var Ach: LETTER; var A, A1: MATRIX; N, InRC: integer);
    var
      Count, C, CL, CU, K, R, RL, RU: integer;
      Z: VECTOR;
  begin
    for R := 1 to N do
      begin
        for C := 1 to N do
          begin
            A[R, C] := 0;
            A1[R, C] := A[R, C];
          end;
      end;
    WRITELN('     Input the elements of the ', N : 1, ' by ', N : 1, ' coefficient matrix  ', Ach);
    RL := 1;
    RU := N;
    CL := 1;
    CU := N;
    if (Mtype = LowerT) and (InRC = 1) then
      begin
        for R := 1 to N do
          begin
            WRITELN;
            case R of
              1: 
                WRITELN('ENTER   A[1,1]');
              2:
                WRITELN('ENTER   A[2,1]   A[2,2]   on one row');
              3:
                WRITELN('ENTER   A[3,1]   A[3,2]   A[3,3]   on one row');
              else
                WRITELN('ENTER   A[', R : 1, ',1]   A[', R : 1, ',2]  ...  A[', R : 1, ',', R : 1, ']   on one row');
            end;
            WRITELN;
            for K := 1 to R do
              Z[K] := 0;
            case R of
              1: 
                READLN(Z[1]);
              2: 
                READLN(Z[1], Z[2]);
              3: 
                READLN(Z[1], Z[2], Z[3]);
              4: 
                READLN(Z[1], Z[2], Z[3], Z[4]);
              5: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5]);
              6: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6]);
              7: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7]);
              8: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8]);
              9: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9]);
              10: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9], Z[10]);
            end;
            for C := 1 to R do
              begin
                A[R, C] := Z[C];
                A1[R, C] := A[R, C];
              end;
          end;
      end;
    if (Mtype = UpperT) and (InRC = 1) then
      begin
        for R := 1 to N do
          begin
            WRITELN;
            case R of
              1: 
                WRITELN('ENTER   A[1,1]   A[1,2]  ...  A[1,', N : 1, ']   on one row');
              2: 
                WRITELN('ENTER   A[2,2]   A[2,3]  ...  A[2,', N : 1, ']   on one row');
              else
                WRITELN('ENTER   A[', R : 1, ',', R : 1, ']   A[',R:1,',',R+1:1,']  ...  A[',R:1,',',N:1, ']   on one row');
            end;
            WRITELN;
            for K := 1 to N do
              Z[K] := 0;
            case N - R + 1 of
              1: 
                READLN(Z[1]);
              2: 
                READLN(Z[1], Z[2]);
              3: 
                READLN(Z[1], Z[2], Z[3]);
              4: 
                READLN(Z[1], Z[2], Z[3], Z[4]);
              5: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5]);
              6: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6]);
              7: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7]);
              8: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8]);
              9: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9]);
              10: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9], Z[10]);
            end;
            for C := R to N do
              begin
                A[R, C] := Z[C - R + 1];
                A1[R, C] := A[R, C];
              end;
          end;
      end;
    if (InRC = 1) and (Mtype <> LowerT) and (Mtype <> UpperT) then
      begin
        for R := 1 to N do
          begin
            WRITELN;
            WRITELN('ENTER all the coefficients of row ', R, ' on one row');
            WRITELN;
            for K := 1 to N do
              Z[K] := 0;
            case N of
              1: 
                READLN(Z[1]);
              2: 
                READLN(Z[1], Z[2]);
              3: 
                READLN(Z[1], Z[2], Z[3]);
              4: 
                READLN(Z[1], Z[2], Z[3], Z[4]);
              5: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5]);
              6: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6]);
              7: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7]);
              8: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8]);
              9: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9]);
              10: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9], Z[10]);
            end;
            for C := 1 to N do
              begin
                A[R, C] := Z[C];
                A1[R, C] := A[R, C];
              end;
          end;
      end;
    if (InRC = 2) then
      begin
        for R := 1 to N do
          begin
            WRITELN;
            WRITELN('     ENTER the coefficients of row ', R);
            WRITELN;
            if Mtype = LowerT then
              CU := R;
            if Mtype = UpperT then
              CL := R;
            for C := CL to CU do
              begin
                WRITE('     A(', R : 1, ',', C : 1, ') = ');
                READLN(A[R, C]);
                A1[R, C] := A[R, C];
              end;
          end;
      end;
    if (InRC = 3) then
      begin
        for C := 1 to N do
          begin
            WRITELN;
            WRITELN('     ENTER the coefficients of column ', C);
            WRITELN;
            if Mtype = LowerT then
              RL := C;
            if Mtype = UpperT then
              RU := C;
            for R := RL to RU do
              begin
                WRITE('     A(', R : 1, ',', C : 1, ') = ');
                READLN(A[R, C]);
                A1[R, C] := A[R, C];
              end;
          end;
      end;
    if Mtype = LowerT then
      begin
        for R := 1 to N do
          for C := 1 to R do
            begin
              A[C, R] := A[R, C];
              A1[C, R] := A[C, R];
            end;
      end;
    if Mtype = UpperT then
      begin
        for R := 1 to N do
          for C := R to N do
            begin
              A[C, R] := A[R, C];
              A1[C, R] := A[C, R];
            end;
      end;
    Mtype := Square;
  end;                                   {End of procedure INPUTMATRIX}

  procedure REFRESH (var A: MATRIX; A1: MATRIX; N: integer);
    var
      C, R: integer;
  begin
    for R := 1 to N do
      begin
        for C := 1 to N do
          begin
            A[R, C] := A1[R, C];
          end;
      end;
  end;

  procedure PrintResults (A, A1: MATRIX; D: VECTOR; N: integer);
    var
      C, J, R: integer;
      A0: real;
  begin
    CLRSCR;
    WRITELN;
    WRITELN;
    WRITELN('The matrix  A  is:');
    for R := 1 to N do
      begin
        WRITELN;
        for C := 1 to N - 1 do
          WRITE(A1[R, C] : 15 : 8, ' ');
        WRITE(A1[R, N] : 15 : 8);
        if N > 5 then
          WRITELN;
      end;
    WRITELN;
    WRITELN;
    WRITELN;
    WRITELN('The similar diagonal matrix is:');
    for R := 1 to N do
      begin
        WRITELN;
        for C := 1 to N - 1 do
          WRITE(A[R, C] : 15 : 8, ' ');
        WRITE(A[R, N] : 15 : 8);
        if N > 5 then
          WRITELN;
      end;
    WRITELN;
    writeln;
    for j := 1 to N do
      writeln('the ', j : 1, ' th eigenvalue is  ', d[j] : 15 : 7);
    writeln;
    readln;
  end;                                {End of procedure PrintResults}

  procedure CHANGEMATRIX (Ach: LETTER; var A, A1: MATRIX; N: integer);
    type
      STATUS = (Bad, Enter, Done);
      LETTER = string[1];
    var
      Count, C, I, J, K, R: integer;
      Valu: real;
      Resp: LETTER;
      Stat: STATUS;
  begin
    Stat := Enter;
    while (Stat = Enter) or (Stat = Bad) do
      begin
        CLRSCR;
        Aoutput(A1, 0, N);
        WRITELN;
        Stat := Enter;
        for I := 1 to N do
          for J := I + 1 to N do
            begin
              if A[I, J] <> A[J, I] then
                begin
                  R := I;
                  C := J;
                  Stat := Bad;
                end;
            end;
        if (Stat = Bad) then
          begin
            WRITELN('The matrix is NOT symmetric, you must change an element.');
          end;
        if (Stat <> Bad) then
          begin
            WRITE('Do you want to make a change in the matrix ? <Y/N> ');
            READLN(Resp);
          end;
        if (Resp = 'Y') or (Resp = 'y') or (Stat = Bad) then
          begin
            WRITELN;
            WRITELN('     To change a coefficient select');
            case N of
              2: 
                begin
                  WRITELN('        the row    R = 1,2');
                  WRITELN('        and column C = 1,2');
                end;
              3: 
                begin
                  WRITELN('        the row    R = 1,2,3');
                  WRITELN('        and column C = 1,2,3');
                end;
              else
                begin
                  WRITELN('        the row    R = 1,2,...,', N : 2);
                  WRITELN('        and column C = 1,2,...,', N : 2);
                end;
            end;
            WRITELN;
            WRITE('     ENTER the row R = ');
            READLN(R);
            WRITE('     ENTER column  C = ');
            READLN(C);
            if (1 <= R) and (R <= N) and (1 <= C) and (C <= N) then
              begin
                WRITELN;
                WRITELN('     The current value is   A(', R : 1, ',', C : 1, ')  =', A[R, C] : 15 : 7);
                if A[R, C] <> A[C, R] then
                  begin
                    WRITELN('     Which is NOT equal to  A(', C : 1, ',', R : 1, ')  =', A[C, R] : 15 : 7);
                    WRITELN('     The computer will set  A(', R : 1, ',', C : 1, ')  =  A(', C, ',', R, ')');
                    WRITELN;
                  end;
                WRITE('     ENTER the  NEW  value  A(', R : 1, ',', C : 1, ') = ');
                READLN(A[R, C]);
                A1[R, C] := A[R, C];
                A[C, R] := A[R, C];
                A1[C, R] := A[C, R];
              end;
          end
        else
          Stat := Done;
      end;
  end;

  procedure MESSAGE (var InRC: integer; var Mtype: MatType);
    var
      I: integer;
      Ans: LETTER;
  begin
    CLRSCR;
    WRITELN('                         THE QL ALGORITHM');
    WRITELN;
    WRITELN;
    WRITELN('     Assume that A is real, symmetric and tridiagonal. Start with A  = A.');
    WRITELN('                                                                   1     ');
    WRITELN;
    WRITELN('The QL method constructs a sequence of orthogonal matrices {Q } such that');
    WRITELN('                                                             k           ');
    WRITELN;
    WRITELN('A  = Q  L  where L  is lower-triangular. Then A    is generated by');
    WRITELN(' k    k  k        k                            k+1  ');
    WRITELN;
    WRITELN('                 A     =  Q  A  Q        for   k = 1,2, ... .');
    WRITELN('                  k+1      k  k  k      ');
    WRITELN;
    WRITELN('The success of the method depends on the result that   lim  A  = D,  where');
    WRITELN('                                                      k->oo  k            ');
    WRITELN;
    WRITELN('D is a diagonal matrix with the same eigenvalues as the original matrix A.');
    WRITELN;
    WRITELN;
    WRITE('                      Press the  <ENTER>  key.  ');
    READLN(Ans);
    CLRSCR;
    for I := 1 to 5 do
      WRITELN;
    WRITELN('     Now you must choose how the symmetric matrix A will be input.');
    WRITELN;
    WRITELN('You can enter all the elements or only the lower or upper portion.?');
    WRITELN;
    WRITELN('If you enter a portion of the matrix then the other elements will');
    WRITELN;
    WRITELN('be computed by symmetry.');
    WRITELN;
    WRITELN;
    WRITELN('     < 1 > Enter the complete  N by N  symmetric matrix.');
    WRITELN;
    WRITELN;
    WRITELN('     < 2 > Enter the lower-triangular portion of the matrix.');
    WRITELN;
    WRITELN;
    WRITELN('     < 3 > Enter the upper-triangular portion of the matrix.');
    WRITELN;
    WRITELN;
    WRITE('           SELECT your choice for input  < 1 - 3 > ? ');
    I := 1;
    READLN(I);
    if (I < 1) or (3 < I) then
      I := 1;
    if I = 1 then
      Mtype := Square;
    if I = 2 then
      Mtype := LowerT;
    if I = 3 then
      Mtype := UpperT;
    CLRSCR;
    WRITELN;
    WRITELN('        Choose how you want to input the elements of the matrix.');
    WRITELN;
    WRITELN('    <1> Enter the elements of each row on one line separated by spaces, i.e.');
    WRITELN;
    WRITELN('        A(J,1)  A(J,2)  ...  A(J,N)           for J=1,2,...,N');
    WRITELN;
    WRITELN('    <2> Enter each element of a row on a separate line, i.e.');
    WRITELN;
    WRITELN('        A(J,1)');
    WRITELN('        A(J,2)');
    WRITELN('           .');
    WRITELN('           :');
    WRITELN('        A(J,N)     for J=1,2,...,N');
    WRITELN;
    WRITELN('    <3> Enter each element of a column on a separate line, i.e.');
    WRITELN;
    WRITELN('        A(1,K)');
    WRITELN('        A(2,K)');
    WRITELN('           .');
    WRITELN('           :');
    WRITELN('        A(N,K)     for K=1,2,...,N');
    WRITELN;
    WRITE('        SELECT <1 - 3> ? ');
    InRC := 3;
    READLN(InRC);
    if (InRC <> 1) and (InRC <> 2) and (InRC <> 3) then
      InRC := 2;
  end;                                  {End of procedure MESSAGE}

  procedure INPUTS (var A, A1: MATRIX; var N, InRC: integer);
    var
      C, I, R: integer;
  begin
    CLRSCR;
    WRITELN('    We will now proceed with the QL method of iteration to reduce the');
    WRITELN;
    WRITELN('tridiagonal matrix  A  to diagonal form.');
    WRITELN;
    WRITELN('           A  must be a tridiagonal matrix of dimension  N by N.');
    WRITELN;
    WRITELN('          {N  must be an integer between 1 and 10}');
    WRITELN;
    WRITE('    ENTER  N  = ');
    N := 2;
    READLN(N);
    if (N < 1) then
      N := 1;
    if (N > 10) then
      N := 10;
    CLRSCR;
    Ach := 'A';
    INPUTMATRIX(Ach, A, A1, N, InRC);
  end;                                   {End of procedure INPUTS}

  procedure PROCESSES;
    var
      I: integer;
  begin
    CLRSCR;
    for I := 1 to 5 do
      WRITELN;
    WRITELN('          To what extent do you want to control the program?');
    WRITELN;
    WRITELN;
    WRITELN('          < 1 > The computer does it all automatically.');
    WRITELN;
    WRITELN;
    WRITELN('          < 2 > As the computer works, we observe each step.');
    WRITELN;
    WRITELN;
    WRITE('          SELECT your choice for input  < 1 - 2 > ? ');
    I := 1;
    READLN(I);
    if (I < 1) or (2 < I) then
      I := 2;
    if I = 1 then
      Proc := Auto;
    if I = 2 then
      Proc := Observe;
  end;

begin                                            {Begin Main Program}
  MESSAGE(InRC, Mtype);
  DoMo := Go;
  while (DoMo = Go) or (DoMo = New) do
    begin
      if DoMo = Go then
        INPUTS(A, A1, N, InRC)
      else
        begin
          WRITELN;
          WRITE('Want a completely new matrix ? <Y/N> ');
          READLN(Ans);
          if (Ans = 'Y') or (Ans = 'y') then
            INPUTS(A, A1, N, InRC)
          else
            REFRESH(A, A1, N);
          WRITELN;
        end;
      CHANGEMATRIX(Ach, A, A1, N);
      PROCESSES;
      QL_ITERATION(A, D, N);
      CLRSCR;
      PrintResults(A, A1, D, N);
      WRITELN;
      WRITE('Want to try a new matrix ? <Y/N> ');
      READLN(Ans);
      if (Ans = 'Y') or (Ans = 'y') then
        begin
          DoMo := New;
          WRITELN;
        end
      else
        DoMo := Stop;
    end;
end.                                            {End of Main Program}

